<?php
if ( $user_post_type ) :

$post_type_obj = get_post_type_object( $user_post_type );

//global $wp_query;

// echo '<pre>';
// var_dump($wp_query);
// echo '</pre>';

switch ($user_post_type) {
    case 'eruahaus-project':
        $eruahaus_project_creation_landing_page_id = ( get_field('eruahaus_project_creation_landing_page', 'option') ) ?? null;
        $form_link = ( $eruahaus_project_creation_landing_page_id ) ? get_permalink($eruahaus_project_creation_landing_page_id) . '#publish' : null;
        $content_name = __('Project', 'erua');
        break;
    case 'showroom':
        $eruahaus_showroom_presentation_creation_page_id = ( get_field('eruahaus_showroom_presentation_creation_page', 'option') ) ?? null;
        $form_link = ( $eruahaus_showroom_presentation_creation_page_id ) ? get_permalink($eruahaus_showroom_presentation_creation_page_id) . '#publish' : null;
        $content_name = __('Presentation', 'erua');
        break;
    case 'creative-blog-post':
        $form_link = ( get_post_type_archive_link('creative-blog-post') ) ?? null;
        if ( $form_link ) $form_link .= '#publish';
        $content_name = __('Post', 'erua');
        break;
    case 'post':
        $form_link = ( get_post_type_archive_link('post') ) ?? null;
        if ( $form_link ) $form_link .= '#publish';
        $content_name = __('Post', 'erua');
        break;
    case 'event':
        $form_link = site_url('events/#publish');
        $content_name = __('Event', 'erua');
        break;
}

$title = 'My ' . $post_type_obj->labels->name;
$description = 'Viewing all your submitted ' . $post_type_obj->labels->name;
?>

<section id="contributions-section">

<div id="contributions-section-header">
    <div id="contributions-section-title">
    <?php
    echo (isset($title)) ? $title : 'title';
    ?>
    </div> <i id="contributions-sync-button" class="fa fa-sync-alt" aria-hidden="true" title="<?php _e('refresh list', 'erua') ?>" data-post-type="<?php echo $user_post_type; ?>"></i>
    <div id="contributions-section-description">
    <?php
    echo '<span>';
    echo (isset($description)) ? $description : 'description';
    echo '</span>';
    ?>
    </div>
    <div id="contributions-section-post-count">
    <span title="<?php printf( _n( "Viewing %s {$post_type_obj->labels->singular_name}", "Viewing %s {$post_type_obj->labels->name} out of %s {$post_type_obj->labels->name}", $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?>">
    <?php
    printf( _n( "%s {$post_type_obj->labels->singular_name}", "%s {$post_type_obj->labels->name}", $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) );
    ?>
    </span>
    </div>
    <?php if ( $form_link ) : ?>
    <div id="contributions-create-new">
        <a class="create-content-button" role="button" href="<?php echo $form_link; ?>"><i class="fa-solid fa-upload" aria-hidden="true"></i> <?php echo __('Add New', 'erua') . ' ' . $content_name; ?></a>
    </div>
    <?php endif; ?>
</div>

<?php if ( $wp_query->have_posts() ) : ?>

<table id="contributions-table">
<!-- <thead>
    <tr>
        <th>Subject</th>
        <th>Status</th>
        <th>Priority</th>
        <th>Applicant</th>
        <th>Date</th>
    </tr>
</thead> -->
<tbody id="contributions-table-body">

<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

<tr>
    <td>
    <span class="contribution-link">
    <i class="fa-solid fa-link contribution-link-icon" aria-hidden="true"></i>
    <?php the_title( sprintf( '<a href="%s" title="'.esc_attr(get_the_title()).'">', esc_url( get_permalink() ) ), '</a>' ); ?>
    </span>
    <span class="contribution-info">
    <?php
    // if ( get_the_author() ) {
    //     echo '<i class="fas fa-user" aria-hidden="true" title="'. __('Applicant', 'erua') .'"></i> <a href="' . get_author_posts_url( get_the_author_meta( 'ID' ) ) . '">' . get_the_author() . '</a>';
    // }
    ?>
    <?php echo '<span class="contribution-date" title="' . __('Last updated:', 'erua') .' ' . get_the_modified_date('j F Y, H:i') .'"><i class="fa fa-calendar" aria-hidden="true" title="'.__('Date created', 'erua').'"></i> ' . get_the_time('j F Y, H:i') . '</span>'; ?>
    <?php
    if ( 'eruahaus-project' === $user_post_type && function_exists('bp_is_active') ) {
        $group_id = get_field('eruahaus_project_group_id', $post_id);

        if ( $group_id ) {
            $group_obj = groups_get_group( (int) $group_id );
            $project_group_url = bp_get_group_permalink( $group_obj );
            echo '<a class="project-group-link" role="button" href="' . $project_group_url . 'admin/"><i class="fa-solid fa-users-viewfinder" aria-hidden="true"></i> ' . __('Manage Team Space', 'erua') . '</a>';
        }
    }
    echo '<a class="post-edit-link" role="button" href="' . get_edit_post_link(get_the_ID()) . '"><i class="fa-regular fa-pen-to-square" aria-hidden="true"></i> ' . __('Edit', 'erua') . '</a>';
    ?>
    </span>
    </td>
</tr>

<?php endwhile; ?>
</tbody>
</table>

<?php
if ( $wp_query->max_num_pages > 1 ) :
?>
    <div id="contributions-pagination" class="pagination contributions-pagination">
        <?php
        $big = 99999999999; // an unlikely big integer
        echo paginate_links( [
            'base'            => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            //'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
            'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
            'current'         => max( 1, $wp_query->query_vars['paged'] ),
            'total'           => $wp_query->max_num_pages,
            'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
            'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
        ] );
        ?>
    </div>
</section>
<?php
endif; // $wp_query->max_num_pages
?>
<?php
else:
    echo '<p class="lead">' . __('No contributions were found', 'erua') . '</p>';
endif; // $wp_query->have_posts()

// Restore original post data.
wp_reset_postdata();
endif;
