<?php
/**
 * Block Name: Hackathon Awards
 *
 * This is the template that displays the Hackathon Awards block.
 */

// create id attribute for specific styling
$id = 'hackathon-awards-' . $block['id'];

// create align class ("alignwide") from block setting ("wide")
$align_class = $block['align'] ? 'align' . $block['align'] : '';

// $classes = ['block-awards'];
// if( !empty( $block['className'] ) )
//     $classes = array_merge( $classes, explode( ' ', $block['className'] ) );

// $anchor = '';
// if( !empty( $block['anchor'] ) )
//     $anchor = ' id="' . sanitize_title( $block['anchor'] ) . '"';

// https://wordpress.stackexchange.com/questions/347021/how-can-i-access-core-paragraph-textcolor-in-a-block-template
$template = array(
    array('core/heading', array(
        'level' => 2,
        'content' => 'Awards',
        'textAlign' => 'center',
    )),
    array( 'core/paragraph', array(
        'content' => "Awards Information.",
    ) )
);
?>
<div id="<?php echo $id; ?>" class="hackathon-awards <?php echo $align_class; ?>">
    <div id="hackathon-awards"><?php echo '<InnerBlocks template="' . esc_attr( wp_json_encode( $template ) ) . '" />'; ?></div>
</div>
<style type="text/css">
    #<?php echo $id; ?> {
        background: <?php the_field('hackathon_awards_background_color'); ?>;
        color: <?php the_field('hackathon_awards_text_color'); ?>;
    }
</style>