<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/science-society/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-12 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                $job_opportunities_page_id = ( get_field('job_opportunities_page', 'option') ) ?? null;
                                $job_opportunities_page_url = ( $job_opportunities_page_id ) ? get_permalink($job_opportunities_page_id) : null;

                                $job_opportunity_status = get_the_terms(get_the_ID(), 'job-opportunity-status');
                                $job_opportunity_is_open_for_application = get_field('job_opportunity_is_open_for_application', get_the_ID());
                                $job_opportunity_deadline = get_field('job_opportunity_deadline', get_the_ID());
                                $job_opportunity_website = get_field('job_opportunity_website', get_the_ID());
                                $job_opportunity_other_important_information = get_field('job_opportunity_other_important_information', get_the_ID());

                                $job_opportunity_field_taxonomy = get_taxonomy('job-opportunity-field');
                                $job_opportunity_domain_taxonomy = get_taxonomy('job-opportunity-domain');
                                $job_opportunity_profile_taxonomy = get_taxonomy('job-opportunity-profile');
                                $job_opportunity_keyword_tags = get_taxonomy('job-opportunity-keyword');

                                $job_opportunity_type = get_the_terms(get_the_ID(), 'job-opportunity-type');
                                $job_opportunity_provider = get_the_terms(get_the_ID(), 'job-opportunity-provider');
                                $job_opportunity_fields = get_the_terms(get_the_ID(), 'job-opportunity-field');
                                $job_opportunity_domains = get_the_terms(get_the_ID(), 'job-opportunity-domain');
                                $job_opportunity_profiles = get_the_terms(get_the_ID(), 'job-opportunity-profile');
                                $job_opportunity_keywords = get_the_terms(get_the_ID(), 'job-opportunity-keyword');

                                // if ( $job_category ) {
                                //     echo '<h3 id="job-category">' . $job_category[0]->name . '</h3>';
                                // }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . get_the_title() . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                                }

                                if ( $job_opportunity_reference_number = get_field('job_opportunity_reference_number') ) {
                                    echo '<p id="job-reference-number" class="text-center">' . __('Ref. No.', 'erua') . ' ' . $job_opportunity_reference_number . '</p>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit job)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_job = is_singular( 'job-opportunity' );
                                if ( $single_job && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_job && 'job-opportunity' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php //if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                                    <div class="entry-image relative">
                                        <?php //get_template_part( 'template-parts/posts/partials/entry-image', 'default' ); ?>
                                        <a href="<?php the_permalink();?>" style="display: flex; justify-content: center; margin: 0 auto 20px auto; width: fit-content;">
                                            <?php the_post_thumbnail('large'); ?>
                                        </a>
                                        <?php //if ( get_theme_mod( 'blog_badge', 1 ) ) get_template_part( 'template-parts/posts/partials/entry', 'post-date' ); ?>
                                    </div>
                                <?php //endif; ?>
                            <?php endif; ?>
                        </header>
                        <div>
                            <div class="accordion alternate-style no-counter table-of-contents">
                                <div id="accordion-ps" class="accordion-item">
                                    <a id="accordion-ps-label" class="accordion-title plain plain" href="#accordion-item-project_sections" aria-expanded="false" aria-controls="accordion-ps-content"> <button class="toggle" aria-label="Toggle"><i class="icon-angle-down"></i></button> <span><?php _e('JOB CONTENT GUIDE', 'erua'); ?></span> </a>
                                    <div id="accordion-ps-content" class="accordion-inner" style="display: none;" aria-labelledby="accordion-ps-label">

                                        <ul>
                                            <li><a href="#job-applications" class="toc-link"><?php _e('Applications', 'erua') ?></a></li>
                                            <li><a href="#job-description" class="toc-link">Description</a></li>
                                            <?php if ($job_opportunity_type) : ?>
                                            <li><a href="#job-type" class="toc-link">Job Type</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_provider) : ?>
                                            <li><a href="#job-provider" class="toc-link">Employer/Provider (Institution/Agency/Organization)</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_fields) : ?>
                                            <li><a href="#job-fields" class="toc-link">Fields (Policy/sectors)</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_domains) : ?>
                                            <li><a href="#job-domains" class="toc-link">Domains</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_profiles) : ?>
                                            <li><a href="#job-profiles" class="toc-link">Job Profiles</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_other_important_information) : ?>
                                            <li><a href="#job-important-info" class="toc-link">Other important information</a></li>
                                            <?php endif; ?>
                                            <?php if ($job_opportunity_keywords) : ?>
                                            <li><a href="#job-keywords" class="toc-link">Keywords</a></li>
                                            <?php endif; ?>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php
                            echo '<h2 id="job-applications">' .__('Applications', 'erua') . '</h2>';
                            if ( $job_opportunity_status ) {
                                echo '<h3 id="job-status">' . __('Status', 'erua') . ' ' . '<span class="job-status-name ' . $job_opportunity_status[0]->slug . '">' . $job_opportunity_status[0]->name . '</span></h3>';
                            }
                            if ( $job_opportunity_deadline ) {
                                echo '<h3 id="job-deadline">' . __('Deadline:', 'erua') . ' ' . '<span class="job-deadline-date">'. $job_opportunity_deadline . '</span></h3>';
                            }
                            if ( $job_opportunity_is_open_for_application && $job_opportunity_website ) {
                                echo '<h3>' .__('Apply for the job:', 'erua') . '</h3>';
                                echo '<p><a id="job-website" href="' . $job_opportunity_website . '" target="_blank" rel="nofollow">' . $job_opportunity_website . '</a></p>';
                            }
                            else {
                                echo '<h3><em>' .__('Applications are closed', 'erua') . '</em></h3>';
                            }
                            ?>
                        </div>
                        <!-- <aside style="padding: 15px; margin-bottom: 30px; border: 1px solid #999;"> -->
                            <?php                            
                            //echo '<div><strong>Year</strong>: ' . get_the_date( 'Y' ) . '</div>';
                            ?>
                        <!-- </aside> -->
                        <?php get_template_part( 'template-parts/single', 'job-opportunity' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <!-- <div class="post-sidebar large-3 col">
            <?php //flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php //flatsome_sidebar_classes(); ?>" role="complementary">
                <?php //do_action( 'before_sidebar' ); ?>
                <?php //if ( ! dynamic_sidebar( 'job-opportunities-sidebar' ) ) : ?>
                <?php //endif; // end sidebar widget area ?>
            </div>
            <?php //flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div> -->
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
