<?php
get_header();
?>

<?php require_once __DIR__ . '/includes/science-society/module-top-section.php'; ?>

<div id="content" class="blog-wrapper blog-single page-wrapper">

    <?php
        do_action('flatsome_before_blog');
    ?>

    <div class="row row-large <?php if(flatsome_option('blog_layout_divider')) echo 'row-divided ';?>">

        <div class="large-12 col">
        <?php
        if( is_single() ) {
            if ( have_posts() ) {

                /* Start the Loop */
                while ( have_posts() ) : the_post();
        ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <div class="article-inner <?php flatsome_blog_article_classes(); ?>">
                        <header class="entry-header">
                            <div class="entry-header-text entry-header-text-top text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
                                <h6 class="entry-category is-xsmall">
                                    <?php echo get_the_category_list( __( ', ', 'flatsome' ) ) ?>
                                </h6>

                                <?php
                                //$hackathons_page_id = ( get_field('hackathons_page', 'option') ) ?? null;
                                //$hackathons_page_url = ( $hackathons_page_id ) ? get_permalink($hackathons_page_id) : null;

                                //$hackathon_short_description = get_field('hackathon_short_description', get_the_ID());
                                $hackathon_date_start = get_field('hackathon_date_start', get_the_ID());
                                $hackathon_date_end = get_field('hackathon_date_end', get_the_ID());
                                $hackathon_registration_url = get_field('hackathon_registration_url', get_the_ID());
                                // $hackathon_steps = get_field('hackathon_steps', get_the_ID());
                                // $hackathon_results = get_field('hackathon_results', get_the_ID());
                                // $hackathon_venue_place = get_field('hackathon_venue_place', get_the_ID());
                                // $hackathon_map_location = get_field('hackathon_map_location', get_the_ID());
                                // $hackathon_topics_challenges = get_field('hackathon_topics_challenges', get_the_ID());
                                //$hackathon_awards = get_field('hackathon_awards', get_the_ID());
                                // $hackathon_rules = get_field('hackathon_rules', get_the_ID());
                                // $hackathon_faq = get_field('hackathon_faq', get_the_ID());
                                //$hackathon_agenda = get_field('hackathon_agenda', get_the_ID());
                                $hackathon_additional_information = get_field('hackathon_additional_information', get_the_ID());

                                $datenow = date_create('now', new DateTimeZone('UTC'));
                                $datestart = DateTime::createFromFormat('d/m/Y H:i:s', $hackathon_date_start);
                                $dateend = DateTime::createFromFormat('d/m/Y H:i:s', $hackathon_date_end);

                                $apply_color = [true, false];
                                $title_array = str_split(get_the_title());
                                $title_html = '';

                                if ( is_array($title_array) ) {
                                    foreach($title_array as $char) {
                                        if ( trim($char) && array_rand($apply_color) ) {
                                            $title_html .= '<span style="color: #48f89b">' . $char . '</span>';
                                        }
                                        else {
                                            $title_html .= $char;
                                        }
                                    }
                                }

                                if ( is_single() ) {
                                    echo '<h1 class="entry-title">' . $title_html . '</h1>';
                                } else {
                                    echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . $title_html . '</a></h2>';
                                }

                                if ( is_single() ) {
                                    if ( current_user_can('administrator') ) echo '<a class="post-edit-link" href="' . get_edit_post_link(get_the_ID()) . '">' . __('(Edit Hackathon)', 'erua') . '</a>';
                                }
                                ?>

                                <div class="entry-divider is-divider small"></div>

                                <?php
                                $single_hackathon = is_singular( 'hackathon' );
                                if ( $single_hackathon && get_theme_mod( 'blog_single_header_meta', 1 ) ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php elseif ( ! $single_hackathon && 'hackathon' == get_post_type() ) : ?>
                                    <div class="entry-meta uppercase is-xsmall">
                                        <?php flatsome_posted_on(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="hackathon-navbar">
                                <nav>
                                    <ul>
                                        <?php if ( $datenow > $dateend ) : ?>
                                        <li><a href="#hackathon-results"><?php _e('RESULTS', 'erua'); ?></a></li>
                                        <?php endif; ?>
                                        <li><a href="#hackathon-about"><?php _e('ABOUT THE HACKATHON', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-steps"><?php _e('STEPS', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-venue"><?php _e('VENUE', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-challenges"><?php _e('CHALLENGES', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-awards"><?php _e('AWARDS', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-agenda"><?php _e('AGENDA', 'erua'); ?></a></li>
                                        <li><a href="#hackathon-rules-faq"><?php _e('RULES AND FAQ', 'erua'); ?></a></li>
                                        <?php if ( $datenow < $datestart ) : ?>
                                        <li><a href="#hackathon-registration"><?php _e('REGISTER', 'erua'); ?></a></li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            </div>
                            <!-- <?php //if ( has_post_thumbnail() ) : ?>
                                    <div class="entry-image relative">
                                        <a href="<?php //the_permalink();?>" style="display: flex; justify-content: center; margin: 0 auto 20px auto; width: fit-content;">
                                            <?php //the_post_thumbnail('large'); ?>
                                        </a>
                                    </div>
                            <?php //endif; ?> -->
                        </header>
                        <?php get_template_part( 'template-parts/single', 'hackathon' ); ?>
                    </div>
                </article>
        <?php
                endwhile;
            } else {
                get_template_part( 'no-results', 'index' );
            }
            //comments_template();
        }
        ?>
        </div>
        <!-- <div class="post-sidebar large-3 col">
            <?php //flatsome_sticky_column_open( 'blog_sticky_sidebar' ); ?>
            <div id="secondary" class="widget-area <?php //flatsome_sidebar_classes(); ?>" role="complementary">
                <?php //do_action( 'before_sidebar' ); ?>
                <?php //if ( ! dynamic_sidebar( 'hackathons-sidebar' ) ) : ?>
                <?php //endif; // end sidebar widget area ?>
            </div>
            <?php //flatsome_sticky_column_close( 'blog_sticky_sidebar' ); ?>
        </div> -->
    </div>

    <?php
        do_action('flatsome_after_blog');
    ?>

</div>

<?php
get_footer();
