<?php
/**
 * The blog template file.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

$search_time = timer_stop(0);
$search_query = trim(get_search_query());

get_header();

// echo '<pre>';
// var_dump('test');
// echo '</pre>';

?>

<div id="content" class="blog-wrapper blog-archive page-wrapper">
    <?php do_action('flatsome_before_blog'); ?>

    <div class="row align-center">

        <div class="large-12 col">
            <?php
            /**
             * Search query not empty and long enough.
             * If the above criteria are not met (i.e. they are false),
             * then have_posts() will not ever run.
             */
            if ( $search_query != null && strlen($search_query) >= 3 && have_posts() ) : ?>

            <div id="search-aftermath"><?php _e( 'Your search for', 'erua' ); ?> <span style="font-weight: bold;"><?php echo $search_query; ?></span> <?php _e( 'returned', 'erua' ); ?> <span><?php printf( _n( '%s result in', '%s results in', $wp_query->found_posts, 'erua' ), '<strong>'.number_format_i18n( $wp_query->found_posts ).'</strong>' ); ?> </span> <?php echo  $search_time . ' ' . __( 'seconds', 'erua' ); ?>. <span><?php printf( _n( 'Showing %s result of %s results', 'Showing %s of %s results', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>.</span></div>

            <div id="post-list">

            <?php /* Start the Loop */ ?>
            <?php while ( have_posts() ) : the_post(); ?>

            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="article-thumbnail">
                <?php if ( has_post_thumbnail() ) : ?>
                    <?php if ( ! is_single() || ( is_single() && get_theme_mod( 'blog_single_featured_image', 1 ) ) ) : ?>
                        <div class="entry-image relative">
                            <a href="<?php the_permalink();?>" title="<?php echo wp_strip_all_tags(get_the_title()); ?>" style="display: flex;"><?php the_post_thumbnail('large'); ?></a>
                            <?php if ( get_theme_mod( 'blog_badge', 1 ) ) : ?>
                            <div class="badge absolute top post-date badge-<?php echo flatsome_option('blog_badge_style'); ?>">
                                <div class="badge-inner">
                                    <span class="post-date-day"><?php echo get_the_time('d', get_the_ID()); ?></span><br>
                                    <span class="post-date-month is-small"><?php echo get_the_time('M', get_the_ID()); ?></span>
                                    <span class="post-date-year is-small"><?php echo get_the_time('Y', get_the_ID()); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                </div>
                <div class="article-inner">
                    <header class="entry-header">
                        <div class="entry-header-text entry-header-text-top text-center">
                            <?php
                            $post_type = get_post_type(get_the_ID());
                            switch ($post_type) {
                                case 'aeiforia-project':
                                    $categories_list = get_the_terms( get_the_ID(), 'aeiforia-project-category' );
                                    $taxonomy = get_taxonomy('aeiforia-project-category');
                                    $special = false;
                                    break;
                                case 'eruahaus-project':
                                    $categories_list = get_the_terms( get_the_ID(), 'eruahaus-project-focus-area' );
                                    $taxonomy = get_taxonomy('eruahaus-project-focus-area');
                                    $special = false;
                                    break;
                                case 'showroom':
                                    $categories_list = get_the_terms( get_the_ID(), 'showroom-category' );
                                    $taxonomy = get_taxonomy('showroom-category');
                                    $special = true;
                                    break;
                                case 'creative-blog-post':
                                    $categories_list = get_the_terms( get_the_ID(), 'creative-blog-category' );
                                    $taxonomy = get_taxonomy('creative-blog-category');
                                    $special = false;
                                    break;
                                case 'hackathon':
                                    $categories_list = null;
                                    $taxonomy = null;
                                    $special = true;
                                    break;
                                case 'funding-opportunity':
                                    $categories_list = get_the_terms( get_the_ID(), 'funding-scientific-field' );
                                    $taxonomy = get_taxonomy('funding-scientific-field');
                                    $special = true;
                                    break;
                                case 'job-opportunity':
                                    $categories_list = get_the_terms( get_the_ID(), 'job-opportunity-field' );
                                    $taxonomy = get_taxonomy('job-opportunity-field');
                                    $special = true;
                                    break;
                                case 'event':
                                    $categories_list = get_the_terms( get_the_ID(), 'event-categories' );
                                    $taxonomy = get_taxonomy('event-categories');
                                    $special = true;
                                    break;
                                default:
                                    $categories_list = get_the_category_list( __( ', ', 'erua' ) );
                            }

                            echo '<h6 class="entry-category is-xsmall">';
                            if ( $post_type === 'post' ) {
                                echo $categories_list;
                            }
                            else if ( $post_type && $taxonomy && !$special ) {
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span><a href="' . site_url('/') . $taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                    }
                                }
                            }
                            else if ( $post_type && $taxonomy && $special ) {
                                if ( is_array($categories_list) ) {
                                    foreach($categories_list as $key => $category) {
                                        $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                    
                                        echo '<span>'. $category->name .'</span>' . $separator;
                                    }
                                }
                            }
                            echo '</h6>';

                            echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
                            echo '<div class="entry-divider is-divider small"></div>';
                            ?>
                            <div class="entry-meta uppercase is-xsmall">
                                <?php flatsome_posted_on(); ?>
                            </div>
                        </div>
                    </header>

                    <div class="entry-content">
                        <?php if ( flatsome_option('blog_show_excerpt') || is_search())  { ?>
                        <div class="entry-summary">
                            <?php the_excerpt(); ?>
                            <div class="text-center">
                                <a class="more-link button primary is-outline is-smaller" href="<?php echo get_the_permalink(); ?>"><?php _e('Continue reading <span class="meta-nav">&rarr;</span>', 'erua'); ?></a>
                            </div>
                        </div>
                        <?php } else { ?>
                        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'erua' ) ); ?>
                        <?php
                            wp_link_pages();
                        ?>
                    <?php }; ?>
                    </div>
                    
                    <?php if ( 'page' !== get_post_type() ) : ?>
                    <footer class="entry-meta clearfix">
                            <span class="cat-links">
                            <?php
                            if ( $post_type === 'post' ) {
                                printf( __( 'Posted in %1$s', 'erua' ), $categories_list );
                            }
                            else if ( $post_type && $taxonomy && !$special ) {
                                if ( !empty($categories_list) ) echo __( 'Posted in ', 'erua' );
                                foreach($categories_list as $key => $category) {
                                    $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                
                                    echo '<span><a href="' . site_url('/') . $taxonomy->rewrite['slug'] . '/' . $category->slug . '">'. $category->name .'</a></span>' . $separator;
                                }
                            }
                            else if ( $post_type && $taxonomy && $special ) {
                                if ( !empty($categories_list) ) echo __( 'Posted in ', 'erua' );
                                foreach($categories_list as $key => $category) {
                                    $separator = ( $key === array_key_last($categories_list) ) ? '' : ', ';
                
                                    echo '<span>"'. $category->name .'"</span>' . $separator;
                                }
                            }
                            ?>
                            </span>

                            <?php
                            if ( 'post' == get_post_type() ) :
                                /* translators: used between list items, there is a space after the comma */
                                $tags_list = get_the_tag_list( '', __( ', ', 'erua' ) );
                                if ( $tags_list ) :
                            ?>
                            <span class="sep">&nbsp;|&nbsp;</span>
                            <span class="tags-links">
                                <?php printf( __( 'Tagged %1$s', 'erua' ), $tags_list ); ?>
                            </span>
                            <?php endif; // End if $tags_list ?>
                            <?php endif; // End if 'post' == get_post_type() ?>
                    </footer>
                    <?php endif; // End if 'page' !== get_post_type() ?>
                </div>
            </article>

            <?php endwhile; ?>

            <?php if ( $search_query != null && strlen($search_query) >= 3 ) flatsome_posts_pagination(); ?>

            </div>

            <?php else : ?>

            <section class="no-results not-found">
                <header class="page-title">
                    <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'erua' ); ?></h1>
                </header>

                <div class="page-content">
                    <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'erua' ); ?></p>
                    <?php get_search_form(); ?>
                </div>
            </section>

            <?php endif; ?>
        </div>

    </div>

    <?php do_action('flatsome_after_blog'); ?>
</div>

<?php get_footer(); ?>
