<?php
/**
 * Template Name: Post Submitted Page
 * Template Post Type: page
 *
 * This page template is solely used by the page 
 * that contains the ACF form which is used for submitting 
 * new posts (posts of type "post").
 */

$using_custom_url = get_field('form_origin_page_is_custom_url');

if ( $using_custom_url ) {
    $referer = get_field('form_origin_page_custom_url');
}
else {
    $referer = get_field('form_origin_page'); # site_url('/slug/')
}

// Allow access to this page template only when coming from specific location
if ( empty(wp_get_referer()) || wp_get_referer() !== $referer ) {
    wp_safe_redirect( site_url('/') );
    exit;
}

//================================================================================
// Get header.
//================================================================================

get_header();

//================================================================================
// Display page.
//================================================================================
do_action( 'flatsome_before_page' );

?>

<style>
#thank-you-message-container {
    background-color: #F8F8F8;
    padding: 20px;
    max-width: 800px;
    width: 100%;
    border-top: 4px solid var(--base-green-color);
    border-radius: 4px;
    margin: 0 auto 40px auto;
    font-size: 1.3em;
    line-height: 1.5em;
    text-align: center;
    box-sizing: border-box;
    box-shadow: 0 4px 3px -3px #888;
}
</style>

<section style="margin-top: 40px;">
    <div id="thank-you-message-container">
    <?php
    //echo wp_get_referer();

    // Start the loop.
    while ( have_posts() ) : the_post();

    the_content();

    endwhile;
    ?>
    </div>
</section>

<?php
if ( get_field('form_origin_redirect_to') === true && is_numeric(get_field('form_origin_redirect_to_countdown')) ) :

    $fragment = ( get_field('form_origin_redirect_to_fragment') ) ? get_field('form_origin_redirect_to_fragment') : '';
    $countdown = ( get_field('form_origin_redirect_to_countdown') ) ? (int) get_field('form_origin_redirect_to_countdown') : 5;
    $location = $referer . $fragment;
?>
<script>

    var duration = <?php echo $countdown ?>; // Seconds

	// setTimeout(function() {
	// 	  // Redirect to another page after x milliseconds
    //    window.location = "<?php //echo get_permalink('11'); ?>";
    // }, duration * 1000);

    // Update the count down every 1 second
    var x = setInterval(function() {

        // Display the result in an element of specific id
        document.getElementById('countdown-message').innerHTML = duration;

        duration = duration - 1;

        // If the count down is finished, write some text
        if (duration < 0) {
            clearInterval(x);
            document.getElementById('countdown-message').innerHTML = '<i class="fas fa-undo" aria-hidden="true"></i>';
            window.location = "<?php echo $location; ?>";
        }

    }, 1000);

</script>
<?php endif; ?>

<?php
do_action( 'flatsome_after_page' );
//================================================================================
// Get footer.
//================================================================================

get_footer();
