<?php
/**
 * Template Name: AEIFORIA Projects
 * Template Post Type: page
 * 
 * This page template is solely used by the page
 * that lists the AEIFORIA projects.
 */

//================================================================================
// Generate CSS class for menus.
//================================================================================

/**
 * The nav_menu_css_class filter will let you add CSS classes to specific menu items.
 * We combine that with the get_page_template_slug function to fetch the page template filename, 
 * then we use that with the get_page_templates method of the theme class to get the template name 
 * as defined in the Template Name: header. 
 * 
 * Then we pass that result through sanitize_html_class to make it a valid class name. 
 * Lastly, we add it to the array of classes and return it.
 *
 * https://wordpress.stackexchange.com/a/169818
 */
function aeiforia_archive_page_template_nav_class( $classes, $item ) {
    // only check pages
    if ( 'page' == $item->object ) {
        // if this page has a template assigned
        if( $slug = get_page_template_slug( $item->object_id ) ) {
            // get the array of filenames => template names in the current theme
            $templates = wp_get_theme()->get_page_templates();
            // if there is a template with key matching our filename
            if( isset( $templates[$slug] ) ) {
                // sanitize it and add it to the classes
                $classes[] = sanitize_html_class( $templates[$slug] );
                //$classes[] = 'current-menu-item';
            }
        }
    }
    return $classes;
}
add_filter( 'nav_menu_css_class', 'aeiforia_archive_page_template_nav_class', 10, 2 );

//================================================================================
// Setup CSS and JS.
//================================================================================

function setup_aeiforia_styles() {
    wp_enqueue_style( 'aeiforia-archive-style' );
    wp_enqueue_style( 'acf-forms-style' );
}
add_action('wp_head', 'setup_aeiforia_styles');

//================================================================================
// Setup Page Title.
//================================================================================

function setup_aeiforia_page_title() {
    global $current_term_name;

    if ( is_tax( ['aeiforia-project-category'] ) ) {
        return __('AEIFORIA', 'erua') . ' | ' . $current_term_name . ' &#8211; ' . get_bloginfo( 'name' );
    }
    else {
        return $post->post_title . ' &#8211; ' . get_bloginfo( 'name' );
    }

}
add_filter( 'pre_get_document_title', 'setup_aeiforia_page_title' );

//================================================================================
// Gather page information.
//================================================================================

//$maxposts = get_option('posts_per_page');
//$paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

$aeiforia_taxonomies = []; // Cache with transients? https://developer.wordpress.org/apis/transients/
$aeiforia_taxonomies['aeiforia-project-category'] = get_taxonomy('aeiforia-project-category');
$aeiforia_taxonomies['aeiforia-sustainability-pillar'] = get_taxonomy('aeiforia-sustainability-pillar');
$aeiforia_taxonomies['aeiforia-project-status'] = get_taxonomy('aeiforia-project-status');
$aeiforia_taxonomies['aeiforia-erua-university'] = get_taxonomy('aeiforia-erua-university');
$aeiforia_taxonomies['aeiforia-erua-region'] = get_taxonomy('aeiforia-erua-region');
$aeiforia_taxonomies['aeiforia-erua-stakeholder'] = get_taxonomy('aeiforia-erua-stakeholder');
$aeiforia_taxonomies['aeiforia-funding-source'] = get_taxonomy('aeiforia-funding-source');
$aeiforia_taxonomies['aeiforia-sdg'] = get_taxonomy('aeiforia-sdg');

// Retrieve taxonomy terms
// $aeiforia_project_category_terms = get_terms('aeiforia-project-category', ['hide_empty' => false]);
// $aeiforia_sustainability_pillar_terms = get_terms('aeiforia-sustainability-pillar', ['hide_empty' => false]);
// $aeiforia_project_status_terms = get_terms('aeiforia-project-status', ['hide_empty' => false]);

/**
 * If we are viewing an AEIFORIA custom taxonomy page,
 * then store the custom taxonomy's term in order to use
 * it with WP_Query().
 */
if ( is_tax( ['aeiforia-project-category'] ) ) {
    $current_term_object = get_queried_object();
    $current_term_object_id = $current_term_object->ID;
    $current_term_taxonomy_name = $current_term_object->taxonomy;
    $current_term_taxonomy_name_rewrite_slug = $aeiforia_taxonomies["{$current_term_taxonomy_name}"]->rewrite['slug'];
    $current_term_id = $current_term_object->term_id;
    $current_term_slug = $current_term_object->slug;
    $current_term_name = $current_term_object->name;
    //$current_term_description_first_line = rtrim(strtok($current_term_object->description, "\n")); # Assign first line of category's description
    //$current_term_description_fragments = explode('# Using vector graphic:', $current_term_description_first_line);
    //$current_term_image = esc_html(trim($current_term_description_fragments[1]));

    // If viewing a specific term
    if ( $current_term_slug ) {
        wp_localize_script( 'erua-ajax-filter-projects', 'ajax_taxonomy_archive', $current_term_slug);
        $page_url = get_term_link( $current_term_slug, $current_term_taxonomy_name);
        $page_slug = $current_term_slug;
    }
    // Else viewing all terms (404)
    else {
        wp_localize_script( 'erua-ajax-filter-projects', 'ajax_taxonomy_archive', 'all');
        $page_url = esc_url( get_permalink( get_queried_object_id() ) );
        $page_slug = get_post_field( 'post_name', get_queried_object_id() );
    }

    // If in ERUA Regions
    if ( $current_term_id === 23 ) {
        $filters = ['field_652040f90c530', 'field_65749bbb0699d', 'field_65749bf50699e', 'field_6520428a9b70f', 'field_652042f35647c'];
    }
    // If in ERUA Alliance
    else if ( $current_term_id === 22 ) {
        $filters = ['field_652040f90c530', 'field_6520420c70bae', 'field_6520428a9b70f', 'field_652042f35647c'];
    }
    // If in ERUA Students & Citizens
    else if ( $current_term_id === 29 ) {
        $filters = ['field_652040f90c530', 'field_65749bbb0699d', 'field_6520420c70bae', 'field_6520428a9b70f', 'field_652042f35647c'];
    }
    else {
        $filters = ['field_652040f90c530', 'field_6520420c70bae', 'field_6520428a9b70f', 'field_652042f35647c'];
    }
    
}
// Else not in an AEIFORIA Taxonomy view
else {
    $current_term_taxonomy_name = null;
    $current_term_taxonomy_name_rewrite_slug = null;
    $current_term_id = null;
    $current_term_slug = null;
    $current_term_name = null;
    $page_url = esc_url( get_permalink( get_queried_object_id() ) );
    $page_slug = '';
    $page_title = get_post_field( 'post_title', get_queried_object_id() );

    $parent_pages = get_post_ancestors(get_queried_object_id());
    if ( $parent_pages ) {
        foreach ( $parent_pages as $pid ) {
            $slug = get_post_field( 'post_name', $pid );
            if ( $slug ) {
                $page_slug .= $slug . '/';
            }
        }
    }
    $page_slug .= get_post_field( 'post_name', get_queried_object_id() );

    $filters = ['field_652040f90c530', 'field_6520420c70bae', 'field_6520428a9b70f', 'field_652042f35647c'];
}

//================================================================================
// Build the Query.
//================================================================================

/**
 * These query vars must have been previously declared in the 'query_vars' filter hook,
 * in order to be recognized by WP_Query and get retrieved from the URL.
 */
$project_category_filter = ( is_tax('aeiforia-project-category') )
    ? $current_term_id
    : ( ( get_query_var( 'apc' ) ) ? filter_var( get_query_var( 'apc' ), FILTER_SANITIZE_NUMBER_INT ) : null );

$sustainability_pillar_filter = ( is_tax('aeiforia-sustainability-pillar') )
    ? $current_term_id
    : ( ( get_query_var( 'asp' ) ) ? sanitize_text_field( get_query_var( 'asp' ) ) : null );

$project_status_filter = ( is_tax('aeiforia-project-status') )
    ? $current_term_id
    : ( ( get_query_var( 'project_status' ) ) ? sanitize_text_field( get_query_var( 'project_status' ) ) : null );

$project_universities_filter = ( is_tax('aeiforia-erua-university') )
    ? $current_term_id
    : ( ( get_query_var( 'project_universities' ) ) ? sanitize_text_field( get_query_var( 'project_universities' ) ) : null );

$project_regions_filter = ( is_tax('aeiforia-erua-region') )
    ? $current_term_id
    : ( ( get_query_var( 'project_regions' ) ) ? sanitize_text_field( get_query_var( 'project_regions' ) ) : null );

$project_stakeholders_filter = ( is_tax('aeiforia-erua-stakeholder') )
    ? $current_term_id
    : ( ( get_query_var( 'project_stakeholders' ) ) ? sanitize_text_field( get_query_var( 'project_stakeholders' ) ) : null );

$project_funding_sources_filter = ( is_tax('aeiforia-funding-source') )
? $current_term_id
: ( ( get_query_var( 'project_fs' ) ) ? sanitize_text_field( get_query_var( 'project_fs' ) ) : null );

$project_sdgs_filter = ( is_tax('aeiforia-sdg') )
? $current_term_id
: ( ( get_query_var( 'project_sdgs' ) ) ? sanitize_text_field( get_query_var( 'project_sdgs' ) ) : null );

$keyword_filter = ( get_query_var( 'keywords' ) ) ? sanitize_text_field( get_query_var( 'keywords' ) ) : null;
// echo 'paged: ' . get_query_var( 'paged' );


$sustainability_pillar_terms = array_filter( explode(',', $sustainability_pillar_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_status_terms= array_filter( explode(',', $project_status_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_universities_terms = array_filter( explode(',', $project_universities_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_regions_terms = array_filter( explode(',', $project_regions_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_stakeholders_terms = array_filter( explode(',', $project_stakeholders_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_funding_sources_terms = array_filter( explode(',', $project_funding_sources_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );
$project_sdgs_terms = array_filter( explode(',', $project_sdgs_filter ?? ''), fn($val) => strlen($val ?? '') && ctype_digit($val) );

$query_args = getAeiforiaQueryArguments($project_category_filter, $sustainability_pillar_terms, $project_status_terms, $project_universities_terms, $project_regions_terms, $project_stakeholders_terms, $project_funding_sources_terms, $project_sdgs_terms, $keyword_filter);

// echo '<pre>';
// var_dump($project_category_filter, $sustainability_pillar_filter, $project_status_terms, $project_universities_terms, $project_funding_sources_terms, $project_sdgs_terms, $keyword_filter);
// echo '</pre>';

// Will reset previous WP Query and clear all query vars!
wp_reset_query();
$wp_query = new WP_Query($query_args);

// Set server timezone to UTC+3
//date_default_timezone_set('Europe/Athens');

//================================================================================
// CONTINUE THE PAGE
//================================================================================

acf_form_head();
get_header();
do_action( 'flatsome_before_page' ); ?>

<?php
// echo '<pre>';
// var_dump($project_category_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($sustainability_pillar_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_status_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_universities_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_regions_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_stakeholders_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_funding_sources_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($project_sdgs_filter);
// echo '</pre>';
// echo '<pre>';
// var_dump($keyword_filter);
// echo '</pre>';

// echo '<pre>';
// var_dump($project_category_filter, $sustainability_pillar_terms, $project_status_terms, $project_universities_terms, $project_regions_terms, $project_stakeholders_terms, $project_funding_sources_terms, $project_sdgs_terms, $keyword_filter);
// echo '</pre>';

// echo '<pre>';
// var_dump($query_args);
// echo '</pre>';
?>

<?php require_once __DIR__ . '/../includes/aeiforia/module-top-section.php'; ?>

<header class="entry-header container" style="text-align: center; margin-top: 40px;">
    <div class="container section-title-container alt-divider"><h1 class="section-title section-title-center"><b></b><span class="section-title-main"><i class="fa-solid fa-flask-vial" aria-hidden="true"></i><?php echo $current_term_name; ?></span><b></b></h1></div>
    <!-- <?php //( isset($current_term_taxonomy_name) ) ? print '<div style="margin: -30px 0 40px 0; font-weight: bold;">' . $aeiforia_taxonomies[$current_term_taxonomy_name]->labels->singular_name . ': ' . $current_term_name . '</div>' : ''; ?> -->
    <?php
    if ( $full_description = get_field('aeiforia_category_full_description', 'aeiforia-project-category_' . $current_term_id ) ) {
        echo $full_description;
    }
    ?>
</header>

<div id="content" class="content-area page-wrapper container">
    <hr>

    <h2 style="font-size: 2rem; text-align: center; margin-top: 40px;"><?php _e('Available Projects', 'erua') ?></h2>
    <img style="display: flex; margin: 0 auto; object-fit: cover; text-align: center;" width="100" height="100" src="<?php echo site_url(); ?>/wp-content/uploads/2023/10/environment.png" />

    <form id="projects-search-form" action="" method="post">

        <div id="debug" style="margin: 20px auto;"></div>

        <div class="container" style="display: flex; flex-wrap: wrap; margin-bottom: 60px;">
            <div id="sustainability-pillar-filters">
                <?php
                acf_form([
                    'form' => false,
                    'fields' => ['field_65203a2f9321a', 'field_65203ac070eec'],
                ]);
                ?>
            </div>
            <div id="mobile-filters">
                <button type="button" data-toggle="collapse-filters" data-target=".collapse-mobile"><i class="fa-solid fa-filter"></i> <?php _e('Filters', 'erua'); ?> <i class="fa-solid fa-angle-down"></i></button>
            </div>
            <aside class="project-filters-sidebar collapse-mobile">
                <button type="reset" id="search-clear-filters-button" class="button button-secondary hidden invisible">
                    <?php _e('Reset Filters', 'erua'); ?>
                </button>
                <?php
                acf_form([
                    'form' => false,
                    'fields' => $filters,
                ]);
                //$post_id = acf_get_valid_post_id();
                //echo $post_id;
                ?>
                <input type="hidden" name="_wp_http_referer" value="/aeiforia-sustainable-innovation/" />
                <input type="hidden" name="_ajax_original_page_url" value="<?php echo esc_attr($page_url); ?>" />
                <input type="hidden" name="_ajax_original_page_slug" value="<?php echo esc_attr($page_slug); ?>" />
                <input type="hidden" name="_ajax_original_term_id" value="<?php echo esc_attr($current_term_id); ?>" />
                <input type="hidden" name="_ajax_original_term_name" value="<?php echo esc_attr($current_term_name); ?>" />
                <input type="hidden" name="_ajax_taxonomy" value="<?php echo esc_attr($current_term_taxonomy_name); ?>" />
                <input type="hidden" name="_ajax_taxonomy_rewrite_slug" value="<?php echo esc_attr($current_term_taxonomy_name_rewrite_slug); ?>" />
                <!-- <button id="filter-projects-button" class="button" name="conduct_projects_search" style="left: 50%; transform: translatex(-50%); margin: 0;">Search</button> -->
                <input type="hidden" name="action" value="search_aeiforia_projects" />
            </aside>
            <section class="projects-section" class="col-inner" style="flex: 1;">
                <div id="ajax-loader" class="ajax-loader"><div></div><div></div><div></div></div>
                <div id="projects-container">
                        <?php require_once __DIR__ . '/../includes/aeiforia/project-listings-content.php'; ?>
                </div>
            </section>
        </div>

    </form>

    <hr>

</div>

<script>
jQuery(document).ready(function($) {

    let hasFilters = false;
    const searchFormClearFiltersButton = document.getElementById('search-clear-filters-button');

    function onVisible(element, callback) {
        new IntersectionObserver((entries, observer) => {
          entries.forEach(entry => {
            if(entry.intersectionRatio > 0) {
              callback(element);
              observer.disconnect();
            }
          });
        }).observe(element);
        if(!callback) return new Promise(r => callback=r);
    }

    <?php
    /*-------------------------------------------------------------------
        POPULATE FIELDS FROM QUERY URL FILTERS
    -------------------------------------------------------------------*/
    ?>
    <?php if ($sustainability_pillar_filter) : ?>

    const pillarFilter = document.getElementById('search-by-pillar');
    const pillarFilterChoices = pillarFilter.querySelectorAll("input[type='checkbox']");
    let queryString1 = '<?php echo $sustainability_pillar_filter; ?>';
    let queryArray1 = queryString1.split(',');
    pillarFilterChoices.forEach((input) => {
            if ( queryArray1.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_status_filter) : ?>

    const statusFilter = document.getElementById('search-by-project-status');
    const statusFilterChoices = statusFilter.querySelectorAll("input[type='checkbox']");
    let queryString2 = '<?php echo $project_status_filter; ?>';
    let queryArray2 = queryString2.split(',');
    statusFilterChoices.forEach((input) => {
            if ( queryArray2.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_universities_filter) : ?>

    const universitiesFilter = document.getElementById('search-by-project-universities');
    const universitiesFilterChoices = universitiesFilter.querySelectorAll("input[type='checkbox']");
    let queryString3 = '<?php echo $project_universities_filter; ?>';
    let queryArray3 = queryString3.split(',');
    universitiesFilterChoices.forEach((input) => {
            if ( queryArray3.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_regions_filter) : ?>

    const regionsFilter = document.getElementById('search-by-project-regions');
    const regionsFilterChoices = regionsFilter.querySelectorAll("input[type='checkbox']");
    let queryString4 = '<?php echo $project_regions_filter; ?>';
    let queryArray4 = queryString4.split(',');
    regionsFilterChoices.forEach((input) => {
            if ( queryArray4.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_stakeholders_filter) : ?>

    const stakeholdersFilter = document.getElementById('search-by-project-stakeholders');
    const stakeholdersFilterChoices = stakeholdersFilter.querySelectorAll("input[type='checkbox']");
    let queryString5 = '<?php echo $project_stakeholders_filter; ?>';
    let queryArray5 = queryString5.split(',');
    stakeholdersFilterChoices.forEach((input) => {
            if ( queryArray5.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_funding_sources_filter) : ?>

    const fsFilter = document.getElementById('search-by-project-funding-source');
    const fsFilterChoices = fsFilter.querySelectorAll("input[type='checkbox']");
    let queryString6 = '<?php echo $project_funding_sources_filter; ?>';
    let queryArray6 = queryString6.split(',');
    fsFilterChoices.forEach((input) => {
            if ( queryArray6.includes(input.value) ) {
                input.checked = true;
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ($project_sdgs_filter) : ?>

    const sdgFilter = document.getElementById('search-by-project-sdg-contribution');
    const sdgFilterChoices = sdgFilter.querySelectorAll("input[type='checkbox']");
    let queryString7 = '<?php echo $project_sdgs_filter; ?>';
    let queryArray7 = queryString7.split(',');
    sdgFilterChoices.forEach((input) => {
            if ( queryArray7.includes(input.value) ) {
                input.checked = true;
                input.parentElement.classList.add('selected');
                hasFilters = true;
            }
    });

    <?php endif; ?>
    <?php if ( !empty($keyword_filter) ) : ?>

    const keywordFieldElement = document.getElementById('acf-field_65203a2f9321a');
    let keywordFieldVal = '<?php echo $keyword_filter; ?>';
    $(keywordFieldElement).val(keywordFieldVal);
    hasFilters = true;

    <?php endif; ?>

    if ( hasFilters ) {
        if ( searchFormClearFiltersButton.classList.contains('hidden') ) {
            searchFormClearFiltersButton.classList.remove('hidden');
            onVisible(searchFormClearFiltersButton, () => {
                searchFormClearFiltersButton.classList.remove('invisible');
            });
        }
    }

    <?php
    /*-------------------------------------------------------------------
        Hightlight this page's parent menu item.
    -------------------------------------------------------------------*/
    ?>
    const elements = document.querySelectorAll('.menu-item.AeiforiaArchive');
    for (i = 0; i < elements.length; ++i) {
        elements[i].closest( '.menu-item.menu-item-has-children' ).classList.add('current-menu-parent');
    }

    <?php
    /**
     * Disable acf_form() navigate away warning.
     * https://support.advancedcustomfields.com/forums/topic/disable-acf_form-navigate-away-warning/
     */
    ?>
    jQuery(document).ready(function() {
        acf.unload.active = false;
    });

});
</script>

<?php
do_action( 'flatsome_after_page' );
get_footer();
