<?php

/**
 * Custom Search widget.
 * 
 * Resources:
 * https://lonewolfonline.net/creating-wordpress-widgets/
 * https://www.hostinger.com/tutorials/how-to-create-custom-widget-in-wordpress
 */
class Custom_Search_Widget extends WP_Widget_Search {

    function widget( $args, $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		echo $args['before_widget'];
		if ( $title ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		// Use our custom search form.
        ?>
        <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" id="sideSearch" name="sideSearch" class="searchform" role="search" aria-label="On this page">
            <div class="flex-row relative">
                <?php
                //global $wp_query;
                $placeholder = esc_attr__('Search', 'erua');
                $post_type = get_post_type();
                $is_specific_search = ( is_home() || is_tax() || is_category() || is_archive() || is_post_type_archive() || is_single() ) ? true : false;

                if ( $is_specific_search && 'post' === $post_type ) {
                    $placeholder = esc_attr__('Search posts', 'erua');

                    // https://wordpress.org/support/topic/partial-searches-not-working/
                    // add_filter( 'flatsome_ajax_search_function', function( $query, $args, $defaults ) {
                    //     return array('post');
                    //     $_wp_query = new WP_Query();
                    //     $_wp_query->parse_query( $args );
                    //     return $_wp_query->posts;
                    // } );
                }
                else if ( $is_specific_search && 'aeiforia-project' === $post_type ) {
                    $placeholder = esc_attr__('Search projects', 'erua');
                }
                else if ( $is_specific_search && 'eruahaus-project' === $post_type ) {
                    $placeholder = esc_attr__('Search projects', 'erua');
                }
                else if ( $is_specific_search && 'showroom' === $post_type ) {
                    $placeholder = esc_attr__('Search presentations', 'erua');
                }
                else if ( $is_specific_search && 'creative-blog-post' === $post_type ) {
                    $placeholder = esc_attr__('Search posts', 'erua');
                }
                else if ( $is_specific_search && 'hackathon' === $post_type ) {
                    $placeholder = esc_attr__('Search hackathons', 'erua');
                }
                else if ( $is_specific_search && 'funding-opportunity' === $post_type ) {
                    $placeholder = esc_attr__('Search funding opportunities', 'erua');
                }
                else if ( $is_specific_search && 'job-opportunity' === $post_type ) {
                    $placeholder = esc_attr__('Search job opportunities', 'erua');
                }

                // echo '<pre>';
                // var_dump($wp_query);
                // echo '</pre>';

                // Only search author's posts
                // if $wp_query->query_vars['author__in']
                // <input type="hidden" value="' . $wp_query->query_vars['author__in'] . '" name="author__in" id="author__in" />

                ?>

                <div class="flex-col flex-grow">
                    <input type="search" class="search-field mb-0" name="s" value="<?php echo esc_attr( get_search_query() ); ?>" id="s" placeholder="<?php echo $placeholder; ?>" pattern=".{3,}" oninvalid="this.setCustomValidity('<?php echo _e( 'The field must contain at least 3 characters', 'erua' ); ?>')" onchange="try{setCustomValidity('')}catch(e){}" required />
                    <?php
                    if ( $is_specific_search ) {
                        // IMPORTANT!!! Hidden inputs must be hooked @ flatsome-live-search.js > devbridgeAutocomplete > params
                        echo '<input type="hidden" value="' . get_post_type() . '" name="post_type" id="post_type" />';
                    }
                    ?>
                </div>
                <div class="flex-col">
                    <button type="submit" class="ux-search-submit submit-button secondary button icon mb-0" aria-label="<?php esc_attr_e( 'Submit', 'erua' ); ?>">
                        <?php echo get_flatsome_icon('icon-search'); ?>
                    </button>
                </div>
            </div>
            <div class="live-search-results text-left z-top"></div>
        </form>
        <?php

		echo $args['after_widget'];
    }

}
