<?php
/**
 * This file contains all the theme redirects.
 * Specifically, we want to perform redirection to other pages, 
 * after logging in or out, and after registering, 
 * Also, whenever some types of logged-in users (e.g. normal user or moderator) 
 * try to access the backend etc.
 * 
 * (Note: Consider using "Peter's Login Redirect" plugin, 
 * to redirect Users after registation, login, logout etc.
 * https://www.wpbeginner.com/plugins/how-to-redirect-users-after-successful-login-in-wordpress/
 * https://codex.wordpress.org/Plugin_API/Filter_Reference/login_redirect )
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//-------------------------------------------------------------------
// MY ACCOUNT REDIRECTS
//-------------------------------------------------------------------

function erua_custom_redirects() {

    global $wp;
    //home_url( $wp->request )
    //if ( !is_admin() && !is_user_logged_in() && is_page('register') ) {
    if ( !is_admin() && $wp->request === 'register' ) {
        wp_safe_redirect( home_url( '/my-account/' ), '301' );
        exit;
    }

    // Redirect logged users from the "Lost Password" page
    if ( class_exists( 'woocommerce' ) && is_user_logged_in() && is_account_page() && isset( $wp->query_vars['lost-password'] ) ) {

        // $user = wp_get_current_user();
        // $is_access_blocked = false;
        // $allowed_roles = array('administrator', 'moderator');

        // if ( !array_intersect($allowed_roles, $user->roles) ) {
        //     $is_access_blocked = true;
        // }

        // if ( $is_access_blocked ) {
            // Redirect to the user's main "my account" page - probably their dashboard.
            wp_safe_redirect(wc_get_page_permalink('myaccount'));
            exit;
        //}
    }
}
//add_action( 'template_redirect', 'erua_custom_redirects' );
