<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// MY ACCOUNT
//================================================================================

/**
 * Remove Tabs from WooCommerce's My Account menu.
 * 
 * https://rudrastyh.com/woocommerce/my-account-menu.html
 */
function erua_remove_my_account_links( $menu_links ) {

    unset( $menu_links['edit-address'] ); // Addresses
    unset( $menu_links['orders'] ); // Remove Orders
    unset( $menu_links['downloads'] ); // Disable Downloads

    return $menu_links;
}
add_filter ( 'woocommerce_account_menu_items', 'erua_remove_my_account_links' );

/**
 * Add AFC form head before get_header()
 *
 * https://www.advancedcustomfields.com/resources/acf_form_head/
 * https://stackoverflow.com/questions/67270667/wordpress-page-goes-blank-after-form-submit
 * https://stackoverflow.com/questions/38444557/detect-dashboard-of-woocommerce-my-account-pages
 */
function erua_add_acf_form_head_to_edit_account() {

    global $wp;

    // Add ACF form head to the "edit-account" account subpage
    if ( class_exists( 'woocommerce' ) && is_user_logged_in() && is_account_page() && isset( $wp->query_vars['edit-account'] ) ) {
        acf_form_head();
    }

}
//add_action( 'get_header', 'erua_add_acf_form_head_to_edit_account', 0 );

/**
 * Prepare field values
 * https://www.advancedcustomfields.com/resources/acf-prepare_field/
 * https://www.advancedcustomfields.com/resources/get_field_object/
 */
function erua_acf_form_prepare_edit_account_field( $field ) {

    global $wp;

    // Add ACF form head to the "edit-account" account subpage
    if ( class_exists( 'woocommerce' ) && is_user_logged_in() && is_account_page() && isset( $wp->query_vars['edit-account'] ) ) {
        $user = wp_get_current_user();
        $field['value'] = get_field( $field['key'], "user_{$user->ID}");
        //$value = $field['value'];
        //$label = $field['choices'][ $value ];
        // echo '<pre>';
        // var_dump($field);
        // echo '</pre>';
    }

    return $field;

}
//add_filter('acf/prepare_field/key=field_63015088f7a91', 'erua_acf_form_prepare_edit_account_field'); // User Gender
//add_filter('acf/prepare_field/key=field_62fbec0f46056', 'erua_acf_form_prepare_edit_account_field'); // User Organization

/**
 * Save - my account
 *
 * Good guide:
 * https://rudrastyh.com/woocommerce/edit-account-fields.html
 * 
 * https://wordpress.org/support/topic/how-to-edit-and-save-custom-address-fields-for-woocomerce-my-account-edit-addres/
 * https://stackoverflow.com/questions/65194759/how-do-i-re-order-or-add-priority-to-a-custom-field-on-woocommerce-my-account
 * https://support.advancedcustomfields.com/forums/topic/acf_form-within-another-form-not-working/
 * https://stackoverflow.com/questions/47599050/add-a-custom-field-in-woocommerce-edit-account-page
 */
function erua_action_woocommerce_save_account_details( $user_id ) {

    // echo '<pre>';
    // var_dump($_POST);
    // echo '</pre>';
    // die();

    // if ( isset( $_POST['account_birthday'] ) && ! empty( $_POST['account_birthday'] ) ) {
    //     update_user_meta( $user_id, 'account_birthday', sanitize_text_field( $_POST['account_birthday'] ) );
    // }

    // For Favorite color
    // if ( isset( $_POST['favorite_color'] ) )
    //     update_user_meta( $user_id, 'favorite_color', sanitize_text_field( $_POST['favorite_color'] ) );

    // For Billing email (added related to your comment)
    // if ( isset( $_POST['account_email'] ) )
    //     update_user_meta( $user_id, 'billing_email', sanitize_text_field( $_POST['account_email'] ) );

    // Save Public Profile choice
    //if ( isset( $_POST['acf']['field_63efb538e941b'] ) && ! empty( $_POST['acf']['field_63efb538e941b'] ) ) {
        update_field( 'field_63efb538e941b', sanitize_text_field( $_POST['acf']['field_63efb538e941b'] ), "user_{$user_id}" );
    //}

    // Save User Gender
    //if ( isset( $_POST['acf']['field_63015088f7a91'] ) && ! empty( $_POST['acf']['field_63015088f7a91'] ) ) {
        update_field( 'field_63015088f7a91', sanitize_text_field( $_POST['acf']['field_63015088f7a91'] ), "user_{$user_id}" );
    //}

    // Save User Organization
    //if ( isset( $_POST['acf']['field_62fbec0f46056'] ) && ! empty( $_POST['acf']['field_62fbec0f46056'] ) ) {
        update_field( 'field_62fbec0f46056', sanitize_text_field( $_POST['acf']['field_62fbec0f46056'] ), "user_{$user_id}" );
    //}

    // Save User General Job Profile
    //if ( isset( $_POST['acf']['field_63efac98b22f7'] ) && ! empty( $_POST['acf']['field_63efac98b22f7'] ) ) {
        update_field( 'field_63efac98b22f7', sanitize_text_field( $_POST['acf']['field_63efac98b22f7'] ), "user_{$user_id}" );
    //}

    // Save User Specific Job Profile
    //if ( isset( $_POST['acf']['field_63efadd1bc279'] ) && ! empty( $_POST['acf']['field_63efadd1bc279'] ) ) {
        update_field( 'field_63efadd1bc279', $_POST['acf']['field_63efadd1bc279'], "user_{$user_id}" );
    //}

    // Save User Resume (CV)
    if ( isset( $_POST['acf']['field_63efafbff2e3d'] ) ) {
        if ( is_user_logged_in() && current_user_can('upload_files') ) {

            $attachment_id = (int) $_POST['acf']['field_63efafbff2e3d'];

            global $FILEBIRD_USER_RESUMES_FOLDER;
            $destination_filebird_folder = $FILEBIRD_USER_RESUMES_FOLDER; # 'User Resumes (CVs)'

            // If there's an attachment, then move it to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }
            update_field( 'field_63efafbff2e3d', $attachment_id, "user_{$user_id}" );
        }
    }

    // Save User Address
    update_field( 'field_63efc0e3abe6e', $_POST['acf']['field_63efc0e3abe6e'], "user_{$user_id}" );

    /**
     * Save User Profile Image
     * https://wp-qa.com/how-to-upload-an-image-on-acf-with-update_field-on-wordpress
     * https://wp-qa.com/upload-image-through-update_field-in-acf
     * https://support.advancedcustomfields.com/forums/topic/upload-user-avatar-using-update_field/
     */
    if ( isset( $_POST['acf']['field_62fbf2e1465c9'] ) ) {

        $attachment_id = '';

        // If there's no attachment then use a default image id
        if ( empty($_POST['acf']['field_62fbf2e1465c9']) ) {
            //$attachment_id = 3051; # default image id
            $using_default_image = true;
        }
        else {
            $using_default_image = false;
        }

        /**
         * uploader type will be either "" or "wp" or "basic", the same for all users,
         * even if they don't have the upload_files capability!
         */
        //$is_basic_uploader = ( get_field_object( 'field_62fbf2e1465c9')['uploader'] === 'basic' ) ? true : false;

        if ( is_user_logged_in() && current_user_can('upload_files') ) {
            /**
             * If the user has the upload_files capability,
             * then he'll be able to use the WordPress uploader.
             */

            $attachment_id = ($using_default_image) ? $attachment_id : (int) $_POST['acf']['field_62fbf2e1465c9'];

            global $FILEBIRD_USER_AVATARS_FOLDER;
            $destination_filebird_folder = $FILEBIRD_USER_AVATARS_FOLDER; # 'User Avatars'

            // If there's an attachment, then move it to the appropriate FileBird folder.
            if ( $attachment_id !== 0 && !$using_default_image && filebird_folder_exists( $destination_filebird_folder ) ) {
                move_attachment_to_filebird_folder( $attachment_id, $destination_filebird_folder );
            }
            update_field( 'field_62fbf2e1465c9', $attachment_id, "user_{$user_id}" );
        }
        else if ( ! current_user_can('upload_files') ) {
            // C://fakepath/filename

            /**
             * If the user doesn't have the upload_files capability,
             * then he'll have to use the "basic" browser uploader,
             * which requires us to somehow get the uploaded attachment id before calling update_field...
             * (probably best way to do it is to get it with AJAX before saving the account form)
             * 
             * Useful resources:
             * https://wp-qa.com/wordpress-ajax-file-upload-frontend
             * https://support.advancedcustomfields.com/forums/topic/custom-validation/
             * https://stackoverflow.com/questions/15638046/how-to-upload-an-image-on-acf-with-update-field-on-wordpress
             * https://support.advancedcustomfields.com/forums/topic/how-to-show-acf-fields-on-woocommerce-checkout-page/#post-45552
             */
            echo '<pre>';
            var_dump('Uploading denied.');
            echo '</pre>';
            die();
        }

    }

    // Save User Bio
    //if ( isset( $_POST['acf']['field_63efba5ca7216'] ) && ! empty( $_POST['acf']['field_63efba5ca7216'] ) ) {
        update_field( 'field_63efba5ca7216', trim( $_POST['acf']['field_63efba5ca7216'] ), "user_{$user_id}" );
    //}

    // echo '<pre>';
    // var_dump($_POST);
    // echo '</pre>';
    // die();

}
//add_action( 'woocommerce_save_account_details', 'erua_action_woocommerce_save_account_details', 10, 1 );

// Validate - my account
function erua_action_woocommerce_save_account_details_errors( $args ){
    if ( isset( $_POST['account_birthday'] ) && empty( $_POST['account_birthday'] ) ) {
        $args->add( 'error', __( 'Please provide a birth date', 'woocommerce' ) );
    }
}
//add_action( 'woocommerce_save_account_details_errors','erua_action_woocommerce_save_account_details_errors', 10, 1 );

//================================================================================
// VARIOUS WOOCOMMERCE SHOP MODIFICATIONS
//================================================================================

/**
 * WooCommerce disables author archives for customers. 
 * In our case, a customer is also a member and therefore we need the author.php template accessible. 
 * The following removes WooCommerce redirect from authors.php template for the 'customer' role.
 * 
 * https://wp-qa.com/how-do-i-enable-author-pages-for-the-role-of-customer
 */
remove_action('template_redirect', 'wc_disable_author_archives_for_customers', 10 );

/* Allow customers to access wp-admin */
//add_filter( 'woocommerce_prevent_admin_access', '__return_false' );
//add_filter( 'woocommerce_disable_admin_bar', '__return_false' );

/**
 * Change subcategories thumbnail size.
 *
 * https://woocommerce.com/document/image-sizes-theme-developers/#section-4
 * https://stackoverflow.com/questions/46218530/use-different-size-thumbnails-for-subcategories-and-products-in-woocommerce
 */
function erua_size_of_category_thumb( $size ) {
    return array(600, 600, true);
}
add_filter('subcategory_archive_thumbnail_size', 'erua_size_of_category_thumb');

/**
 * Change add to cart text
 * https://stackoverflow.com/questions/48354487/change-the-add-to-cart-text-for-a-specific-product-category-in-woocommerce-3
 */
add_filter( 'woocommerce_product_add_to_cart_text', 'product_cat_add_to_cart_button_text', 20, 1 );
function product_cat_add_to_cart_button_text( $text ) {
    // Only for a specific product category archive pages
    // if( is_product_category( array('preorder') ) ) {
    //     $text = __( 'Preorder', 'woocommerce' );
    // }

    if ( get_theme_mod( 'catalog_mode' ) ) {
        $text = __( 'View', 'erua' );
    }

    return $text;
}

//================================================================================
// RELATED AND UPSELL PRODUCTS
//================================================================================

/**
 * Remove related when using Upsells
 * https://wordpress.org/support/topic/remove-related-when-using-upsell/
 */
function related_upsell_products() {
	global $product;

	if ( isset( $product ) && is_product() ) {
		$upsells = version_compare( WC_VERSION, '3.0', '<' ) ? $product->get_upsells() : $product->get_upsell_ids();

		if ( count( $upsells ) > 0 ) {
			woocommerce_upsell_display();
		} else {
			woocommerce_upsell_display();
			woocommerce_output_related_products();
		}
    }
}
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action( 'woocommerce_after_single_product_summary', 'related_upsell_products', 15 );

/**
 * Rename Related Products title
 * https://stackoverflow.com/questions/45688753/rename-related-products-title-in-woocommerce-3
 */
add_filter('woocommerce_product_related_products_heading', function() {

    return __('See also', 'erua');

});

/**
 * Rename Product Upsells title
 */
add_filter( 'woocommerce_product_upsells_products_heading', function() {

    return __('See also', 'erua');

});
