<?php if ( $wp_query->have_posts() ) : ?>

<h2 id="results-title">
    <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s funding opportunity of %s funding opportunities', 'Showing %s of %s funding opportunities', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php printf( _n( 'There is %s funding opportunity', 'There are %s funding opportunities', $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) ); ?></span>
</h2>

<ul class="fundings-list">
<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    <?php //do_action( 'flatsome_before_page_content' ); ?>

        <?php
        $funding_opportunity_field_terms = get_the_terms( get_the_ID(), $funding_taxonomies['funding-scientific-field']->name );
        $funding_opportunities_page_id = ( get_field('funding_opportunities_page', 'option') ) ?? null;

        // How can i put "posted x minutes ago on my posts?
        // https://wordpress.stackexchange.com/questions/36184/how-can-i-put-posted-x-minutes-ago-on-my-posts
        ?>

        <li class="funding">
            <!-- <?php //if ( has_post_thumbnail() ) : ?>
            <div class="funding-image">
                <a class="funding-link" href="<?php //echo get_permalink(); ?>" title="<?php //echo esc_attr(get_the_title()); ?>"><?php //the_post_thumbnail('medium') ?></a>
            </div>
            <?php //endif; ?> -->
            <div class="funding-info">
                <div class="funding-info-inner">
                    <h2 class="funding-title"><a class="funding-link two-line-box" href="<?php echo get_permalink(); ?>" title="<?php echo esc_attr(get_the_title()); ?>">
                        <span class="funding-text"><?php echo get_the_title(); ?></span>
                    </a></h2>
                    <div class="funding-fields">
                    <?php
                    if ( is_array($funding_opportunity_field_terms) ) {
                        foreach ( $funding_opportunity_field_terms as $key => $funding_field ) {
                            //$separator = ( $key === array_key_last($funding_opportunity_field_terms) ) ? '' : ', ';
    
                            //echo '<a class="button primary is-smaller lowercase" href="' . site_url('/') . $funding_taxonomies['funding-scientific-field']->rewrite['slug'] . '/' . $funding_field->slug . '"> <span>'. $funding_field->name .'</span> </a>';
                            if ( $funding_opportunities_page_id ) {
                                echo '<a class="button primary is-smaller lowercase" href="' . get_permalink($funding_opportunities_page_id) . '?funding_sf='.$funding_field->term_id.'"> <span>'. $funding_field->name .'</span> </a>';
                            }
                            else {
                                echo '<a class="button primary is-smaller lowercase"> <span>'. $funding_field->name .'</span> </a>';
                            }
                        }
                    }
                    ?>
                </div>
                </div>
            </div>
            <div class="funding-date-status">
                <div class="funding-dates">
                    <div class="funding-posted-date">
                        <span class="posted-date-title"><?php echo __('Date posted', 'erua'); ?></span>
                        <span class="posted-date-formatted"><strong><?php echo get_field('funding_opportunity_publication_date'); ?></strong></span>
                    </div>
                    <div class="funding-deadline-date">
                        <span class="deadline-date-title"><?php echo __('Deadline', 'erua'); ?></span>
                        <span class="deadline-date-formatted"><strong><?php echo get_field('funding_opportunity_deadline'); ?></strong></span>
                    </div>
                </div>
                <?php
                $funding_status = get_field('funding_opportunity_status');
                if ( $funding_status ) {
                    $funding_status_name = $funding_status->name;
                    switch($funding_status->term_id) {
                        case 206 : # Open
                            $funding_status_class = 'success';
                            break;
                        case 207 : # Closed
                            $funding_status_class = 'alert';
                            break;
                        case 208 : # Forthcoming
                            $funding_status_class = 'primary';
                            break;
                    }
                }
                else {
                    $funding_status_name = __('Unknown', 'erua');
                    $funding_status_class = 'unknown';
                }
                ?>
                <div class="funding-status">
                    <?php if ( $funding_opportunities_page_id ) : ?>
                    <a class="button <?php echo $funding_status_class; ?> expand" href="<?php echo get_permalink($funding_opportunities_page_id) . '?funding_status='.$funding_status->term_id; ?>"><span><?php echo __('Status:', 'erua') . ' ' . $funding_status_name; ?></span></a>
                    <?php else : ?>
                    <a class="button <?php echo $funding_status_class; ?> expand"><span><?php echo __('Status:', 'erua') . ' ' . $funding_status_name; ?></span></a>
                    <?php endif; ?>
                    <span class="funding-date"><?php echo __('Last updated on: ', 'erua') . get_the_modified_date( 'd/m/Y' ); ?></span>
                </div>
            </div>
        </li>

    <?php //do_action( 'flatsome_after_page_content' ); ?>
<?php endwhile; // end of the loop. ?>
</ul>

<div id="fundings-pagination" class="pagination fundings-pagination">
<?php
$big = 99999999999; // an unlikely big integer
// https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
echo paginate_links( [
    //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
    'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
    //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
    'current'         => max( 1, $wp_query->query_vars['paged'] ),
    'total'           => $wp_query->max_num_pages,
    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
] );
?>
</div>

<?php
else :
echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No funding opportunities found.', 'erua') . '</p>';
endif;

// Restore original post data.
wp_reset_postdata();
