<?php if ( $wp_query->have_posts() ) : ?>

<h2 id="results-title">
    <span style="display: inline-block;" title="<?php printf( _n( 'Showing %s project of %s projects', 'Showing %s of %s projects', $wp_query->post_count, $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->post_count ), number_format_i18n( $wp_query->found_posts ) ); ?> @ <?php echo __('page', 'erua') . ' ' . max( 1, $wp_query->query_vars['paged'] ) . ' ' . __('of', 'erua') . ' ' . max( 1, $wp_query->max_num_pages ); ?>"><?php echo __('ERUAHAUS has', 'erua') . ' ';  printf( _n( '%s project', '%s projects', $wp_query->found_posts, 'erua' ), number_format_i18n( $wp_query->found_posts ) ); ?></span>
</h2>

<ul class="projects-list">
<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
    <?php //do_action( 'flatsome_before_page_content' ); ?>

        <?php
        $eruahaus_project_focus_area_terms = get_the_terms( get_the_ID(), $eruahaus_taxonomies['eruahaus-project-focus-area']->name );
        $eruahaus_erua_university_terms = get_the_terms( get_the_ID(), $eruahaus_taxonomies['eruahaus-erua-university']->name );
        ?>

        <li class="project">
            <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php the_permalink(); ?>" title="<?php esc_attr(the_title()); ?>" class="project-image-link">
                <?php the_post_thumbnail('medium'); ?>
            </a>
            <?php endif; ?>
            <div class="project-inner">
                <?php $project_status = get_field('eruahaus_project_status'); ?>
                <span class="project-status <?php echo ( $project_status ) ? $project_status->slug : 'active' ?>"><?php echo ( $project_status ) ? $project_status->name : __('Active', 'erua'); ?></span>
                <div class="project-focus-areas">
                    <?php
                    if ( is_array($eruahaus_project_focus_area_terms) ) {
                        foreach ( $eruahaus_project_focus_area_terms as $key => $eruahaus_project_focus_area ) {
                            $separator = ( $key === array_key_last($eruahaus_project_focus_area_terms) ) ? '' : ', ';
    
                            echo '<span class="project-focus-area"><a href="' . site_url('/') . $eruahaus_taxonomies['eruahaus-project-focus-area']->rewrite['slug'] . '/' . $eruahaus_project_focus_area->slug . '">'. $eruahaus_project_focus_area->name .'</a></span>' . $separator;
                        }
                    }
                    ?>
                </div>

                <span class="project-title"><a href="<?php echo get_permalink(); ?>"><i class="fa fa-file-text-o" aria-hidden="true"></i> <?php echo get_the_title(); ?></a></span>
                <div class="project-info">
                    <span><?php echo get_the_date() . ' by <a href="' . get_author_posts_url(get_the_author_meta( 'ID' )) . '">' . get_the_author() . '</a> <i class="fa fa-comments-o" aria-hidden="true"></i> ' . '<a href="'. esc_url( get_permalink() ) .'" title="' . get_comments_number( '0 comments', '1 comment', '% comments' ) .'" class="commentscount">'. get_comments_number( '0', '1', '%' ) .'</a>'; ?></span>
                </div>
                <a class="project-view-button" role="button" href="<?php the_permalink(); ?>"><?php _e('View the Project', 'erua'); ?></a>
                <div>
                    <p style="margin-bottom: 0;"><strong><?php _e('ERUA University/ies:', 'erua'); ?></strong></p>
                    <!-- <i class="fa fa-tags" aria-hidden="true"></i> -->
                    <?php
                    if ( is_array($eruahaus_erua_university_terms) ) {
                        foreach ( $eruahaus_erua_university_terms as $key => $eruahaus_erua_university ) {
                            $separator = ( $key === array_key_last($eruahaus_erua_university_terms) ) ? '' : ', ';
    
                            echo '<span class="project-topic"><a href="' . site_url('/') . $eruahaus_taxonomies['eruahaus-erua-university']->rewrite['slug'] . '/' . $eruahaus_erua_university->slug . '">'. $eruahaus_erua_university->name .'</a></span>' . $separator;
                        }
                    }
                    ?>
                </div>
            </div>
            <?php //the_content(); ?>
        </li>

    <?php //do_action( 'flatsome_after_page_content' ); ?>
<?php endwhile; // end of the loop. ?>
</ul>

<div id="projects-pagination" class="pagination projects-pagination">
<?php
$big = 99999999999; // an unlikely big integer
// https://wordpress.stackexchange.com/questions/303297/paginate-link-generate-additional-038-whenever-my-url-have-multiple-query-stri
echo paginate_links( [
    //'base'            => str_replace( $big, '%#%', html_entity_decode( get_pagenum_link( $big ) ) ),
    'base'            => str_replace( [ $big, '&#038;' ], [ '%#%', '&' ], get_pagenum_link( $big ) ),
    //'base'            => str_replace( $big, '%#%', get_pagenum_link( $big, false ) ),
    'format'          => '/page/%#%', # '/page/%#%' or '?paged=%#%'
    'current'         => max( 1, $wp_query->query_vars['paged'] ),
    'total'           => $wp_query->max_num_pages,
    'prev_text'       => __( '<span class="meta-nav"><i class="fa-solid fa-chevron-left" aria-hidden="true"></i></span> Previous', 'erua' ),
    'next_text'       => __( 'Next <span class="meta-nav"><i class="fa-solid fa-chevron-right" aria-hidden="true"></i></span>', 'erua' ),
] );
?>
</div>

<?php
else :
echo '<p style="text-align: center; font-size: 2em; margin-top: 50px;">' . __('No projects found.', 'erua') . '</p>';
endif;

// Restore original post data.
wp_reset_postdata();
