<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

//================================================================================
// Build the Breadcrumb trail.
//================================================================================

$breadcrumbs = [];
$aeiforia_landing_page_id = ( get_field('aeiforia_landing_page', 'option') ) ?? null;

// (1) Add the Site's home page to the breadcrumb trail
$breadcrumbs[] = [
    get_site_url(),
    __('Home', 'erua')
];

// (2) Add Module Root
if ( $aeiforia_landing_page_id ) {
    // Add the Site's home page to the breadcrumb trail
    $breadcrumbs[] = [
        get_permalink($aeiforia_landing_page_id),
        get_the_title($aeiforia_landing_page_id)
    ];
}

// (3) Add current view
if ( ! is_tax() && ! is_archive() && ! is_singular('aeiforia-project') && $aeiforia_landing_page_id !== get_the_ID() ) {
    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_singular('aeiforia-project') ) {
    $aeiforia_project_category_taxonomy = get_taxonomy('aeiforia-project-category');
    $project_category = get_the_terms( get_the_ID(), 'aeiforia-project-category' );
    if ( $project_category ) {
        $breadcrumbs[] = [
            get_site_url() . '/' . $aeiforia_project_category_taxonomy->rewrite['slug'] . '/' . $project_category[0]->slug,
            'in ' . $project_category[0]->name
        ];
    }

    $breadcrumbs[] = [
        get_permalink(get_the_ID()),
        get_the_title(get_the_ID())
    ];
}
else if ( is_tax('aeiforia-project-category') ) {
    global $current_term_taxonomy_name_rewrite_slug, $current_term_slug, $current_term_name;
    $breadcrumbs[] = [
        get_site_url() . '/' . $current_term_taxonomy_name_rewrite_slug . '/' . $current_term_slug,
        'in ' . $current_term_name
    ];
    $page_title = __('Projects by', 'erua') . ' ' . $current_term_name;
}
else if ( is_tax() ) {
    $current_term_object = $wp_query->get_queried_object();
    $current_taxonomy = get_taxonomy($current_term_object->taxonomy);
    $page_title = $current_taxonomy->labels->singular_name . ': ' . $current_term_object->name;

    $breadcrumbs[] = [
        get_site_url() . '/' . $current_taxonomy->rewrite['slug'] . '/' . $current_term_object->slug,
        $page_title
    ];
}
else if ( is_archive('aeiforia-project') ) {
    $page_title = get_the_archive_title();
    $breadcrumbs[] = [
        get_post_type_archive_link('aeiforia-project'),
        $page_title
    ];
}

//================================================================================
// Build the Module Title.
//================================================================================

$title = ( ! is_tax() && ! is_archive() ) ? get_the_title(get_the_ID()) : $page_title;

?>
<section class="module-top section aeiforia" style="padding-bottom: 0; z-index: 2;">
    <div class="bg section-bg fill bg-fill bg-loaded"></div>
    <div class="section-content relative">
        <div class="row row-full-width">
            <div class="col small-12 large-12" style="padding-bottom: 0;">
                <div class="col-inner">
                    <ol class="breadcrumb">
                        <?php foreach( $breadcrumbs as $breadcrumb ) : ?>
                        <li class="breadcrumb-item"><a href="<?php echo $breadcrumb[0]; ?>"><span><?php echo $breadcrumb[1]; ?></span></a></li>
                        <?php endforeach; ?>
                    </ol>
                    <div class="module-title"><h3 class="module-heading"><?php echo $title; ?></h3></div>
                    <?php echo do_shortcode('[aeiforia_menu]'); ?>
                </div>
            </div>
        </div>
    </div>
</section>